/** This class contains the static methods used to
    anglicize integers in the range 1..999,999.
    Method anglicize1 contains the first, functional, solution
    Method anglicize contains the second solution */
public class Anglicize {

   /** = English equivalent of n, for 0 < n < 1,000,000 */
   public static String anglicize(int n) {
      String s= "";  // anglicize(n) = s + anglicize(k)
      int k= n;
      
      if (k >= 1000) {
         s= s + anglicize(k/1000) + "thousand ";
         k= k % 1000;
      }
      if (k >= 100) {
         s= s + digitName(k/100) + "hundred ";
         k= k % 100;
      }
      if (k >= 20) {
         s= s + tensName(k/10);
         k= k % 10;
      }
      if (k >= 10) {
         s= s + teenName(k);
         k= 0;
      }
      if (k > 0) {
         s= s + digitName(k);
         k= 0;
      }
      return s;
   }
   
   
   /** = English equivalent of n, for 0 < n < 1000000 */
   public static String anglicize1(int n) {
      if (n >= 1000) {
         return anglicize2(n/1000) + "thousand " + anglicize2(n%1000);
      }
      return anglicize2(n);
   }
  
   /** = English equivalent of n, for 0 < n < 1000 */
   public static String anglicize2(int n) {
      if (n >= 100) {
         return digitName(n/100) + "hundred " + anglicize3(n%100);
      }
      return anglicize3(n);
   }
   
   /** = English equivalent of n, for 0 < n < 100 */
   public static String anglicize3(int n) {
      if (n >= 20) {
         return tensName(n/10) + digitName(n%10);
      }
      if (n >= 10) {
         return teenName(n);
      }
      return digitName(n);
   }

   /** = name of n, for 0 < n < 10
       = "", if n = 0  */
   public static String digitName(int n) {
      if (n == 0) return "";
      if (n == 1) return "one ";
      if (n == 2) return "two ";
      if (n == 3) return "three ";
      if (n == 4) return "four ";
      if (n == 5) return "five ";
      if (n == 6) return "six ";
      if (n == 7) return "seven ";
      if (n == 8) return "eight ";
      return "nine ";
   }
   
   /** = name of n, for 10 <= n <= 19 */
   public static String teenName(int n) {
      if (n == 10) return "ten ";
      if (n == 11) return "eleven ";
      if (n == 12) return "twelve ";
      if (n == 13) return "thirteen ";
      if (n == 14) return "fourteen ";
      if (n == 15) return "fifteen ";
      if (n == 16) return "sixteen ";
      if (n == 17) return "seventeen ";
      if (n == 18) return "eighteen ";
      return "nineteen ";
   }

   /** = name of 10*n, for 2 <= n <= 9 */
   public static String tensName(int n) {
      if (n == 2) return "twenty ";
      if (n == 3) return "thirty ";
      if (n == 4) return "forty ";
      if (n == 5) return "fifty ";
      if (n == 6) return "sixty ";
      if (n == 7) return "seventy ";
      if (n == 8) return "eighty ";
      return "ninety ";
   }
}
